<?php
    $items = array(
		array('Htaccess Generator', 'htaccess-generator.php', 'icon-cog'),
		array('Robots.txt Generator', 'robots-txt-generator.php', 'icon-globe'),
		array('Sitemap Generator', 'sitemap-generator.php', 'icon-briefcase'),
		array('Robot Mode', 'robot-mode.php', 'icon-hdd'),
		array('Speed Test', 'speed-test.php', 'icon-time'),
		array('Meta Tags Generator', 'meta-tags-generator.php', 'icon-wrench'),
		array('Keyword Cleaner', 'keyword-cleaner.php', 'icon-refresh'),
		array('Keyword Generator', 'keyword-generator.php', 'icon-cog'),
		array('PageRank Lookup', 'pagerank-lookup.php', 'icon-stats'),
		array('Backlink Lookup', 'backlink-lookup.php', 'icon-resize-small'),
		array('Indexed Pages Lookup', 'indexed-pages-lookup.php', 'icon-list-alt'),
		array('Character Length', 'character-length.php', 'icon-text-width'),
		array('Password Generator', 'password-generator.php', 'icon-asterisk'),
		array('Hash Generator', 'hash-generator.php', 'icon-lock'),
		array('Whois Lookup', 'whois-lookup.php', 'icon-question-sign'),
		array('HTTP Header Lookup', 'http-header-lookup.php', 'icon-info-sign'),
		array('Graphs and Charts', 'graphs-and-charts.php', 'icon-adjust'),
		array('Script Resources', 'script-resources.php', 'icon-paperclip'),
		array('Live HTML Editor', 'live-html-editor.php', 'icon-pencil'),
		array('PayPal Generator', 'paypal-generator.php', 'icon-tags'),
		array('Map Image Generator', 'map-image-generator.php', 'icon-map-marker')
	);

    if(isset($_POST['doFormPostback'])) {
        $db['Disabled'] = array();
        
        foreach($items as $item) {
            $disabled = isset($_POST['Disable_' . md5($item[1])]);
            if($disabled) {
                $db['Disabled'][] = $item[1];
            }
        }
        
        file_put_contents("../data/main.db", json_encode($db));
        
        $saved = true;
    }
?>

<div class="wrapper">
    <h3 style="margin-top: 0px;">Features</h3>
    <?php if(isset($saved)) { ?>
        <div class="alert alert-success"><strong>Changes saved!</strong> Now live on the public website.</div>
    <?php } ?>
</div>
<div class="wrapper">
    <form action="" method="post">
        <p>Place a checkmark on any features you wish to disable (hide from the navigation list).</p>
        
        <input type="hidden" name="doFormPostback" value="1">

        <?php
            $i = 0;
            foreach($items as $item) {
                $i++;
        ?>
        <label class="formColumnLabel" for="cb<?php echo $i; ?>">
            <input type="checkbox" id="cb<?php echo $i; ?>" name="Disable_<?php echo md5($item[1]); ?>"<?php if(in_array($item[1], $db['Disabled'])) { ?>checked<?php } ?>>
            &nbsp; <?php echo $item[0]; ?>
        </label><br />
        <?php
            }
        ?>
        
        <br/>

        <input type="submit" class="btn btn-primary" value="Save Changes">
    </form>
</div>